// tests/test_book.cpp
#include <boost/test/auto_unit_test.hpp>

#include "../src/author.hpp"
#include "../src/book.hpp"

BOOST_AUTO_TEST_SUITE(Book_test_suite);
BOOST_AUTO_TEST_CASE(testCtors) {
    cAuthor author("Samuel", "Beckett");
    cBook book("Endspiel", author);
    BOOST_CHECK(book.getTitle() == "Endspiel");
    BOOST_CHECK(book.getAuthor().getFirstName() == "Samuel");
    BOOST_CHECK(book.getAuthor().getLastName() == "Beckett");
}
BOOST_AUTO_TEST_CASE(testSetAuthor) {
    cAuthor *author1 = new cAuthor("Samuel", "Beckett");
    cAuthor *author2 = new cAuthor("Graham", "Greene");
    cBook *book = new cBook("Endspiel", *author1);
	book->setAuthor(*author2);
    BOOST_CHECK(book->getTitle() == "Endspiel");
    BOOST_CHECK(book->getAuthor().getFirstName() == "Graham");
    BOOST_CHECK(book->getAuthor().getLastName() == "Greene");
	delete author1;
	delete author2;
	delete book;
}
BOOST_AUTO_TEST_SUITE_END();


//BOOST_AUTO_TEST_CASE_EXPECTED_FAILURES(testSetAuthor, 5);
