#include <fstream>
#include <boost/test/unit_test_log.hpp>
#include <boost/test/output/xml_log_formatter.hpp>
#include <boost/test/unit_test.hpp>

using namespace boost::unit_test;


namespace testauthor {
test_suite *get_test_suite();
}
namespace testbook {
test_suite *get_test_suite();
}

class my_xml_log_formatter : public output::xml_log_formatter {
	void log_start(std::ostream& ostr, counter_t test_cases_amount) {
		ostr << "<?xml version=\"1.0\" encoding='ISO-8859-1' " \
				"standalone='yes' ?>";
		ostr << "<?xml-stylesheet type=\"text/xsl\" " \
				"href=\"unittestlog.xsl\"?>";
		output::xml_log_formatter::log_start(ostr, test_cases_amount);
	}
};

std::ofstream file("unittestlog.xml");

test_suite* init_unit_test_suite( int, char* [] ) {
	unit_test_log.instance().set_stream(file);
	unit_test_log.instance().set_threshold_level(log_successful_tests);
	unit_test_log.instance().set_formatter(new my_xml_log_formatter);
	
    test_suite* test = BOOST_TEST_SUITE( "Main test suite" );
	test->add(testauthor::get_test_suite());
	test->add(testbook::get_test_suite());
	return test;
}


