// tests/test_author.cpp
#include <boost/test/unit_test.hpp>

#include "author.hpp"

namespace ut = boost::unit_test;

namespace testauthor
{
void testCtors(void) {
    cAuthor *author = new cAuthor("Samuel", "Beckett");
    BOOST_CHECK(author->getFirstName() == "Samuel");
    BOOST_CHECK(author->getLastName() == "Becket");
    delete author;
}

void testEmptyAuthorException(void) {
    cAuthor *author = 0;
    BOOST_CHECK_THROW(author = new cAuthor("", ""), 
                      cInvalidAuthor);
    if (author != 0) delete author;
}

ut::test_suite *get_test_suite() {
    ut::test_suite* test= BOOST_TEST_SUITE("Author test suite");
    test->add(BOOST_TEST_CASE(&testCtors));
    test->add(BOOST_TEST_CASE(&testEmptyAuthorException));
    return test;
}
}
