// tests/test_book.cpp
#include <boost/test/unit_test.hpp>

#include "author.hpp"
#include "book.hpp"

namespace ut = boost::unit_test;

namespace testbook
{
void testCtors(void) {
    cAuthor author("Samuel", "Beckett");
    cBook book("Endspiel", author);
    BOOST_CHECK(book.getTitle() == "Endspiel");
    BOOST_CHECK(book.getAuthor().getFirstName() == "Samuel");
    BOOST_CHECK(book.getAuthor().getLastName() == "Beckett");
}

void testSetAuthor(void) {
    cAuthor *author1 = new cAuthor("Samuel", "Beckett");
    cAuthor *author2 = new cAuthor("Graham", "Greene");
    cBook *book = new cBook("Endspiel", *author1);
	book->setAuthor(*author2);
    BOOST_CHECK(book->getTitle() == "Endspiel");
    BOOST_CHECK(book->getAuthor().getFirstName() == "Graham");
    BOOST_CHECK(book->getAuthor().getLastName() == "Greene");
	delete author1;
	delete author2;
	delete book;
}

ut::test_suite *get_test_suite() {
    ut::test_suite* test = BOOST_TEST_SUITE("Book test suite");
    test->add(BOOST_TEST_CASE(&testCtors));
	test->add(BOOST_TEST_CASE(&testSetAuthor));
    return test;
}
}
