<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="3.2" 
            encoding="iso-8859-1" indent="yes"/>
<xsl:template match="TestLog">
  <html><head>
  <title>TestLog</title>
  <link rel="stylesheet" type="text/css" href="unittestlog.css" />
  </head><body>
  <xsl:apply-templates select="TestSuite"/>
  </body></html>
</xsl:template>
<xsl:template match="TestSuite">
  <h1>Testsuite <xsl:value-of select="@name" /></h1>
  <xsl:apply-templates select="TestSuite"/>
  <xsl:apply-templates select="TestCase"/>
</xsl:template>
<xsl:template match="TestCase">
  <h2>Testcase <xsl:value-of select="@name" /></h2>
  <ul>
  <xsl:apply-templates select="Error"/>
  <xsl:apply-templates select="Info"/>
  </ul>
  <xsl:apply-templates select="TestingTime"/>
</xsl:template>
<xsl:template match="Error">
  <li class="error">
  <xsl:value-of select="@file" />
  (<xsl:value-of select="@line" />):
  <xsl:value-of select="." />
  </li>
</xsl:template>
<xsl:template match="Info">
  <li class="info">
  <xsl:value-of select="@file" />
  (<xsl:value-of select="@line" />):
  <xsl:value-of select="." />
  </li>
</xsl:template>
<xsl:template match="TestingTime">
  <p class="time"> Testing time: <xsl:value-of select="." /> </p>
</xsl:template>
</xsl:stylesheet>
