// unittests.cpp
#include <boost/shared_ptr.hpp>
#include <boost/test/unit_test.hpp>
#include <boost/test/parameterized_test.hpp>

using namespace boost::unit_test;

struct cTestSomething {
	void testSomething(float param) {
		BOOST_MESSAGE(param);
	}
};
test_suite* init_unit_test_suite( int, char* [] ) {
    typedef std::vector<float> float_vector_t;
	boost::shared_ptr<float_vector_t> params(new float_vector_t);
	params->push_back(3.1415926535897932384626433832795f);
	params->push_back(2.7182818284590452353602874713527f);
	
    test_suite* testsuite = BOOST_TEST_SUITE( "Main test suite");
	boost::shared_ptr<cTestSomething> 
		test_instance(new cTestSomething);
	testsuite->add(BOOST_PARAM_CLASS_TEST_CASE(
		&cTestSomething::testSomething, 
		test_instance, params->begin(), params->end()));
    return testsuite; 
}
