// unittests.cpp
#include <boost/mpl/vector_c.hpp>
#include <boost/mpl/vector.hpp>
#include <boost/mpl/pair.hpp>
#include <boost/mpl/int.hpp>
#include <boost/test/test_tools.hpp>
#include <boost/test/test_case_template.hpp>
using namespace boost::unit_test;
using namespace boost::mpl;
bool isEven(int num) {
	return (num / 2) + (num / 2) == num;
}
BOOST_TEST_CASE_TEMPLATE_FUNCTION(testEven1, T) {
	BOOST_CHECK(!isEven(T::value));
}
BOOST_TEST_CASE_TEMPLATE_FUNCTION(testEven2, T) {
	BOOST_CHECK_EQUAL(isEven(T::first::value), T::second::value);
}
test_suite* init_unit_test_suite( int, char* [] ) {
    test_suite* testsuite = BOOST_TEST_SUITE( "Main test suite");
	
	typedef vector_c<int,1, 3, 5, 11> odd_nums;
	testsuite->add(BOOST_TEST_CASE_TEMPLATE(testEven1, odd_nums));	
	
	typedef vector<
	  pair<int_<12>, bool_<true> >,
	  pair<int_<1>, bool_<false> >,
	  pair<int_<9>, bool_<false> >,
	  pair<int_<42>, bool_<true> >
	> tbl_nums;            	
	testsuite->add(BOOST_TEST_CASE_TEMPLATE(testEven2, tbl_nums));

    return testsuite; 
}
