// tests/unittests.cpp
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/TextTestRunner.h>

//#define TEXTOUTPUTTER
#define COMPILEROUTPUTTER
//#define XMLOUTPUTTER

#ifdef XMLOUTPUTTER
#include <iostream>
#include <cppunit/XmlOutputter.h>
using namespace CppUnit;
int main() {
	TextTestRunner runner;
	std::ofstream file("unittests.xml");
	XmlOutputter *outputter = new XmlOutputter(&runner.result(), file);
	outputter->setStyleSheet("report.xsl");
    runner.setOutputter(outputter);
	runner.addTest(TestFactoryRegistry::getRegistry().makeTest());
	int result = static_cast<int>(!runner.run());
    file.close();
    return result;
}
#endif

#ifdef COMPILEROUTPUTTER
#include <cppunit/CompilerOutputter.h>
using namespace CppUnit;
int main() {
	TextTestRunner runner;
	CompilerOutputter *outputter = new CompilerOutputter(&runner.result(), std::cout);
	outputter->setLocationFormat("%p(%l) : ");
	//outputter->setWrapColumn(19);
	outputter->setNoWrap();
    runner.setOutputter(outputter);
	runner.addTest(TestFactoryRegistry::getRegistry().makeTest());
    runner.run();
    return 0;
}
#endif


#ifdef TEXTOUTPUTTER_FILE
#include <iostream>
#include <cppunit/TextOutputter.h>
using namespace CppUnit;
int main() {
	TextTestRunner runner;
	std::ofstream file("unittest.log");
	TextOutputter *op = new TextOutputter(&runner.result(), file);
	runner.setOutputter(op);
	runner.addTest(TestFactoryRegistry::getRegistry().makeTest());
    int result = static_cast<int>(!runner.run());
    file.close();
    return result;
}
#endif

#ifdef TEXTOUTPUTTER
using namespace CppUnit;
int main() {
	TextTestRunner runner;
	runner.addTest(TestFactoryRegistry::getRegistry().makeTest());
    int result = static_cast<int>(!runner.run());
    return result;
}
#endif

#ifdef DEFAULTOUTPUTTER
int main() {
	CppUnit::TextTestRunner runner;
    runner.addTest(CppUnit::TestFactoryRegistry::getRegistry(). \
        makeTest());
    return static_cast<int>(!runner.run());
}
#endif
