/* custom.c */
#include <stdio.h>
#include <CUnit/TestRun.h>
#include <custom/custom.h>

static void custom_test_start_message_handler(
    const CU_pTest pTest, const CU_pSuite pSuite);
static void custom_test_complete_message_handler(
    const CU_pTest pTest, const CU_pSuite pSuite, 
    const CU_pFailureRecord pFailure);
static void custom_all_tests_complete_message_handler(
    const CU_pFailureRecord pFailure);
static void custom_suite_init_failure_message_handler(
    const CU_pSuite pSuite);
static void custom_suite_cleanup_failure_message_handler(
    const CU_pSuite pSuite);

CU_ErrorCode CCU_custom_run_tests(void)
{
	CU_set_test_start_handler(
	    custom_test_start_message_handler);
	CU_set_test_complete_handler(
	    custom_test_complete_message_handler);
	CU_set_all_test_complete_handler(
	    custom_all_tests_complete_message_handler);
	CU_set_suite_init_failure_handler(
	    custom_suite_init_failure_message_handler);
	CU_set_suite_cleanup_failure_handler(
	    custom_suite_cleanup_failure_message_handler);

	return CU_run_all_tests();
}

static void custom_test_start_message_handler(
    const CU_pTest pTest, const CU_pSuite pSuite)
{
	static char *suitename = NULL;
	
	if (pSuite->pName != suitename)
	{
		suitename = pSuite->pName;
		printf("Suite %s\n", suitename);
	}
	printf("Test %s\n", pTest->pName);
}

static void custom_test_complete_message_handler(
    const CU_pTest pTest, const CU_pSuite pSuite, 
    const CU_pFailureRecord pFailure)
{
	CU_pFailureRecord p;
	
	if (pFailure == NULL)
	{
		printf("passed\n");
	}
	else
	{
		p = pFailure;
		while (p != NULL)
		{
			printf("%s: %d: failure: %s\n", 
				p->strFileName, 
				p->uiLineNumber, 
				p->strCondition);
			p = p->pNext; 
		}	
	}
}

static void custom_suite_init_failure_message_handler(
    const CU_pSuite pSuite)
{
	printf("Suite %s: Initialization failed\n", pSuite->pName);
}

static void custom_suite_cleanup_failure_message_handler(
    const CU_pSuite pSuite)
{
	printf("Suite %s: Denitialization failed\n", pSuite->pName);
}

static void custom_all_tests_complete_message_handler(
    const CU_pFailureRecord pFailure)
{
	CU_pTestRegistry r = CU_get_registry();
	
	printf("\n==RUN SUMMARY==\nType\tTotal\tRan\tFailed\n");
	printf("Suites\t%d\t%d\t%d\n",
		r->uiNumberOfSuites, 
		CU_get_number_of_suites_run(),
 		CU_get_number_of_suites_failed());
	printf("Tests\t%d\t%d\t%d\n",
		r->uiNumberOfTests,
		CU_get_number_of_tests_run(),
	 	CU_get_number_of_tests_failed());
	printf("Asserts\t%d\t%d\t%d\n",
		CU_get_number_of_asserts(),
		CU_get_number_of_asserts(),
 		CU_get_number_of_failures());
}
