/* utest.c */

#include <setjmp.h>
#include <stdio.h>
#include <time.h>
#include "demo.h"

//#define auto

#include <CUnit/CUnit.h> 
#ifdef auto
#include <CUnit/Automated.h>
#else
#include <custom/custom.h> 
#endif

void test01(void);
void test02(void);
void test03(void);
void test04(void);
void test05(void);
void test06(void);
void test07(void);
void test08(void);
void test09(void);
void test10(void);

int init_dummy_suite(void);

char *timestamp(void)
{
   static char buffer[256];
   time_t curtime;
   struct tm *loctime;
 
   /* Get the current time. */
   curtime = time(NULL);
 
   /* Convert it to local time representation. */
   loctime = localtime(&curtime);
 
   /* Print it out in a nice format. */
   //strftime(buffer, 32, "%F, %T", loctime);
   strftime (buffer, 256, "Test run %d-%m-%Y, %H:%M:%S", loctime);
 
   return buffer;
}

void run_other_func(jmp_buf *buf);

int main(void)
{
	CU_pSuite suite;

	int retval; 

	CU_initialize_registry();
	suite = CU_add_suite("asserttest", NULL, NULL);

	CU_ADD_TEST(suite, test01);	
	CU_ADD_TEST(suite, test02);	
	CU_ADD_TEST(suite, test03);	
	CU_ADD_TEST(suite, test04);	
	CU_ADD_TEST(suite, test05);	
	CU_ADD_TEST(suite, test06);	
	CU_ADD_TEST(suite, test07);	
	CU_ADD_TEST(suite, test08);	
	CU_ADD_TEST(suite, test09);	
	CU_ADD_TEST(suite, test10);	

	suite = CU_add_suite("dummytest", init_dummy_suite, NULL);
	CU_ADD_TEST(suite, test01);	
	
	#ifdef auto
	CU_automated_run_tests();
	#else
	CCU_custom_run_tests();
	#endif

	retval = CU_get_number_of_tests_failed();
	CU_cleanup_registry();
	
	return retval;
}


int init_dummy_suite(void)
{
	return 1;
}


void test01(void)
{
    CU_ASSERT(1 + 2 == 3); /* pass */
    //CU_ASSERT(1 + 2 == 4); /* fail */
    CU_TEST(1 + 2 == 3);    /* pass */
    //CU_TEST(1 + 2 == 4);    /* fail */
}

void test02(void)
{
	CU_ASSERT_TRUE_FATAL(2 == 3);
	CU_ASSERT_FALSE(2 == 2);
}

void test03(void)
{
	jmp_buf buf;
	int i;

	i = setjmp(buf);
	if (i == 0)
	{
		run_other_func(&buf);
		CU_PASS("run_other_func() succeeded.");
	}
	else
	{
		CU_FAIL("run_other_func() issued longjmp.");
	}
}

void test04(void)
{
	CU_ASSERT_EQUAL(1, 2);
	CU_ASSERT_NOT_EQUAL(1, 1);
}

void test05(void)
{
	CU_ASSERT_PTR_EQUAL(NULL, &main);
	CU_ASSERT_PTR_NOT_EQUAL(&main, &main);
}

void test06(void)
{
	CU_ASSERT_PTR_NULL(&main);
	CU_ASSERT_PTR_NOT_NULL(NULL);
}

void test07(void)
{
	char s[] = "blub";
	
	CU_ASSERT_STRING_EQUAL(strtoupper(s), "BLUB");
	CU_ASSERT_STRING_NOT_EQUAL(s, "bLUB");
}

void test08(void)
{
	CU_ASSERT_NSTRING_EQUAL("blub", "blup", 3);
	CU_ASSERT_NSTRING_NOT_EQUAL("blub", "blup", 3);
}

void test09(void)
{
	CU_ASSERT_DOUBLE_EQUAL(1.01, 1.03, 0.01);
	CU_ASSERT_DOUBLE_NOT_EQUAL(1.01, 1.01, 0.01);
}

void test10(void)
{
	CU_ASSERT(0 == 1);
	CU_ASSERT_FATAL(1 == 0);
	CU_TEST(1 == 2 );
}
//TODO!! */
void run_other_func(jmp_buf *buf)
{
	longjmp(*buf, -1);
}
