/* tests/utest_cfgreader.c */

#include <CUnit/CUnit.h> 
#include <CUnit/Basic.h> 
#include <cfgreader.h>

void test01_cfgReadline(void);
void test02_cfgReadline(void);
int init_cfgReadline(void);
int cleanup_cfgReadline(void);

int main(void)
{
	CU_pSuite suite;
	int retval;

	CU_initialize_registry();
	suite = CU_add_suite("cfgReadline", 
	            init_cfgReadline, cleanup_cfgReadline);
	CU_ADD_TEST(suite, test01_cfgReadline);	
	CU_ADD_TEST(suite, test02_cfgReadline);
	CU_basic_run_tests();
	retval = CU_get_number_of_tests_failed();
	CU_cleanup_registry();
	
	return retval;
}

static FILE *fp;
const static char *FILENAME = "test_cfgreader.txt";

int init_cfgReadline(void)
{
	if (NULL == (fp = fopen(FILENAME, "w"))) return -1;
	if (EOF == fputs("First line\n", fp)) return -1;
	if (EOF == fputs("Last line\n", fp)) return -1;
	if (0 != fclose(fp)) return -1;
	if (NULL == (fp = fopen(FILENAME, "r"))) return -1;
	return 0;
}

int cleanup_cfgReadline(void)
{
	fclose(fp);
	remove(FILENAME);
	return 0;
}

void test01_cfgReadline(void)
{
	CU_ASSERT_STRING_EQUAL(cfgReadline(fp), "First line");
	CU_ASSERT_STRING_EQUAL(cfgReadline(fp), "Last line");
	fseek(fp, 0L, SEEK_SET);
}

void test02_cfgReadline(void)
{
	CU_ASSERT_STRING_EQUAL(cfgReadline(fp), "First line");
	CU_ASSERT_STRING_EQUAL(cfgReadline(fp), "Last line");
	CU_ASSERT_PTR_NULL(cfgReadline(fp));
	fseek(fp, 0L, SEEK_SET);
}

