/* @file 
 */
 
//! Eine Person
struct person_t
{	
	char *name; //!< Vor -und Nachname
	int age;       //!< Alter
};

/** @brief Kurzbeschreibung der Beispielklasse
 *
 *  Ausfhrliche Beschreibung der Beispielklasse
 */
class DemoClass {
public:
	//! Variable (public, static)
	static int PublicStaticVar;
	//! Variable (public, static)
	static int AnotherPublicStaticVar;
	//! Variable (public, automatic)
	int PublicVar;
	//! Funktion (public, inline)
	inline int PublicInlineFunc();

	//!  friend-Funktion
	friend int friend_function(void);
	//!  friend-Klasse
	friend class FriendClass;
private:
	//!  Variable (private, static)
	static int PrivateStaticVar;
	//!  Variable (private, automatic)
	int PrivateVar;
protected:
	//!  Variable (protected, automatic)
	int ProtectedVar;
	//!  Variable (protected, static)
	static int ProtectedStaticVar;
	//!  Funktion (protected, static)
	static int ProtectedStaticFunc();
};

//!  friend-Funktion
int friend_function(void);

//! Eine friend-Klasse
class FriendClass {};
	
//!  Abgeleitete Klasse
class DerivedClass : public DemoClass 
{};
	
	