/** @file */
/*  @nosubgrouping  */
/** Mathematische Funktionen */
class Math
{
    public:
    /** @name Trigonometrische Funktionen 
     * Allgemeine trigonometrische Funktionen. */
    /** @{ */
    /** Sinus-Funktion */
    double sin(double a);
    /* Cosinus-Funktion */
    double cos(double a);
    /** @} */

    /** @name Logarithmus-Funktionen 
     *  Konventionelle Logarithmus-Funktionen */
    /** @{ */
    /** Natrlicher Logarithmus */
    double ln(double a);
    /** Logarithmus dualis */
    double ld(double a);
    
    private:
    /** Argument-Prfung */
    bool check_log_arg(double a);
    /** @} */
    
    private:
    /** @name Mathematische Konstanten */
    /** @{ */
    /** @brief Mathematische Konstante */
    const static double PI;
    const static double E;
    /** @} */
};

/** @name Fehlernummern */
/** @{ */
/** @brief Fehlernummer */
const int UNDERFLOW = -100;
const int OVERFLOW = -101;
/** @} */
