/*! @file print.h
 *  Ausgabefunktionen fr den Datentyp person_t.
 *  Keine Ausgabe fr anonym  (siehe ::anonym)
 *  @see http://www.dpunkt.de, someone@nowhere.all, 
 *  types.h
 */
#include <types.h>

const char *delim = " "; //!< Trennzeichen

/*! @brief Ausgabe von Personendaten
 *
 *  Datenstrukturen sind in types.h definiert.
 *  Ausgegeben wird person_t::vorname gefolgt von
 *  ::delim gefolgt von person_t::nachname.
 *  person_t::delim wird ignoriert.
 */
void print_person(struct person_t *p);

/*! @brief Ausgabe von Personendaten in Kurzform
 *
 *  Wie ::print_person. Im Gegensatz zu print_person()
 *  wird @link person_t::vorname der Vorname @endlink
 *  abgekrzt ausgegeben.
 */
void Ausgabe(struct person_t *p);
