/** @file */

/** Sender classd. Can be used to send a Cmd to the server.
  The receiver will acknowlegde the Cmd by calling Ack().
  \msc
    Sender,Receiver;
    Sender->Receiver [label="Cmd()", URL="\ref Receiver::Cmd()"];
	Receiver=>Receiver [label="ProcessCmd()", URL="\ref Receiver::ProcessCmd()"];
    Sender<-Receiver [label="Ack()", URL="\ref Ack()", ID="1"];
	--- [label="And so on ..."];
  \endmsc
 */
class Sender
{
  public:
    /** Acknowledgement from server */
    void Ack(bool ok);
};

/** 
  Receiver-Klasse. Empfngt Kommandos und fhrt diese aus.
  Anschliessend wird eine Besttigung bermittelt.
  @msc
  Sender,Receiver;
  Sender->Receiver [label="Cmd()", URL="\ref Receiver::Cmd()"];
  Receiver=>Receiver [label="ExecCmd()", URL="\ref Receiver::ExecCmd()"];
  Sender<-Receiver [label="Ack()", URL="\ref Ack()"];
  --- [label="Naechstes Kommando"];
  Sender->Receiver [label="Cmd()", URL="\ref Receiver::Cmd()"];
  @endmsc
 */
class Receiver {
public:
  /** Auswerten eines Kommandos vom Server */
  bool Cmd(int CmdId);
  /** Ausführen des Kommandos */
  void ExecCmd(void);
};
