# Dies sind Beispieldateien zum Buch 
# 
# Achim Khler. Der C/C++-Projektbegleiter - C/C++ Projekte planen, dokumentieren, 
# bauen und testen. dpunkt.verlag GmbH, 2007.
# ISBN-10 3-89864-470-7
# ISBN-13 978-3-89864-470-9
# http://www.dpunkt.de/buecher/3-89864-470-7.html
# 
# Copyright (C) 2007 Achim Koehler
# Verffentlicht unter der Boost Software License, Version 1.0. 
# (Siehe begleitende Datei  LICENSE_1_0.txt oder eine Kopie unter 
# http://www.boost.org/LICENSE_1_0.txt)
# 
# Diese Beispieldateien gehren zum Kapitel 
# "Programme bauen mit make", 
# Seite 130: Einfhrendes Beispiel, Make-Datei mit Musterregeln und mehreren Regeln pro Ziel.

TARGET = demo
CC = gcc
CFLAGS = -pedantic
GGO = gengetopt

$(TARGET): main.o cmdline.o helper.o
	$(CC) -o $@ main.o cmdline.o helper.o

main.o helper.o: helper.h
main.o cmdline.o: cmdline.h
%.o: %.c 
 	$(CC) $(CFLAGS) -c $<

cmdline.c cmdline.h: cmdline.ggo
	$(GGO) -i $< --unamed-opts

.PHONY: clean doc

doc:
	doxygen 

clean:
	-$(RM) main.o helper.o cmdline.o cmdline.c cmdline.h
